/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.IAnalyticsEventHandler;
import com.aptana.usage.IStudioAnalytics;
import com.aptana.usage.UsagePlugin;
import com.aptana.usage.internal.AnalyticsHandlersManager;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class StudioAnalytics
implements IStudioAnalytics {
    public void sendEvent(AnalyticsEvent event) {
        if (Platform.inDevelopmentMode() || EclipseUtil.isTesting() || !this.isUsageAnalyticsEnabled()) {
            return;
        }
        Set<IAnalyticsEventHandler> handlers = AnalyticsHandlersManager.getInstance().getHandlers();
        for (IAnalyticsEventHandler handler : handlers) {
            handler.sendEvent(event);
        }
    }

    private boolean isUsageAnalyticsEnabled() {
        IScopeContext configScope = ConfigurationScope.INSTANCE;
        boolean isStudioAnalyticsEnabled = Platform.getPreferencesService().getBoolean("com.aptana.ui", "com.aptana.usage.enableStudioUsageAnalytics", false, new IScopeContext[]{configScope});
        IdeLog.logInfo((Plugin)UsagePlugin.getDefault(), (String)("Is Studio usage analytics enabled: " + isStudioAnalyticsEnabled), (String)"instance");
        return isStudioAnalyticsEnabled;
    }
}

